<?php

define('ANTI_DIRECT',1);

session_start();

// EXACT DIRECTORY OF THIS FILE - EVEN IF INCLUDED
$_this_dir = dirname(__FILE__);
$_exec = $_this_dir.'/_exec/';
$_modules_dir = $_exec.'modules/';
$where = $_where = '';
// TEMPLATES DIR
$_config['templates_dir'] = $_this_dir.'/templates';

// base install directory
$_file_replacements = array(basename(__FILE__),'plus.php','index.php');
$BASE_URI = str_replace($_file_replacements,'',$_SERVER["SCRIPT_NAME"]);

// loading core
require_once($_exec.'functions.url.php');
require_once($_exec.'config.php');
require_once($_exec.'constants.php');
require_once($_exec.'_sql/ez_sql_core.php');
require_once($_exec.'_sql/ez_sql.php');
require_once($_exec.'_smarty/Smarty.class.php');
require_once($_exec.'functions.misc.php');

// database class
$sql = new ezSQL_mysql($_config['db_user'],$_config['db_pass'],$_config['db_name'],$_config['db_server']);
if(is_dir('./templates/_ezcache')) {
        $sql->cache_dir = './templates/_ezcache';
        $sql->use_disk_cache = true;
        $sql->cache_queries = true;
        $sql->cache_timeout = 3600;
}

// template class
$s = new Smarty;

// CONFIGuration parameters
require_once($_exec.'functions.config.php');

$_GET = sanitize($_GET);
$_POST = sanitize($_POST);
$_FILES = sanitize($_FILES);
$_SERVER = sanitize($_SERVER);
$_COOKIE = sanitize($_COOKIE);
$_REQUEST = sanitize($_REQUEST);

if(!$_GET['module']) $_GET['module'] = $_config['start_module'];

// preventing possible exploits through MODULE variable
if($_GET['module']) $_GET['module'] = str_replace('/','',($_GET['module']));

// CHECKING & DEFINING WORK MODULE
if(!$_GET['module'] || (!is_dir($_modules_dir.$_config['module_prefix'].$_GET['module']) && !is_dir($_modules_dir.$_GET['module']))) {
        $_GET['module'] != 'upload' ? $_GET['user'] = $_GET['module'] : $s->assign('USER_ERROR','Missing file or forbidden user name!');
        $_module = str_replace($_config['module_prefix'],'',$_config['start_module']);
        $_GET['module'] = str_replace($_config['module_prefix'],'',$_config['start_module']);
} else {
        $_module = $_GET['module'];
}

// CHECKING EXECUTE FILE
!$_GET['file'] ? $_GET['file'] = $_file = 'index' : $_file = $_GET['file'];

// loading optional core functionality
require_once($_exec.'auth.php');
require_once($_exec.'functions.access.php');
require_once($_exec.'functions.navigation.php');

// interface language data
$s->assign('USER_ERROR',check_language('Language'));

// plugins directory scan and include
if(is_dir($_exec.'plugins')) {
        $handle = opendir($_exec.'plugins');
        while (false !== ($file = readdir($handle))) {
                if ($file != "." && $file != ".." && $file != "index.php") include_once($_exec.'plugins/'.$file);
        }
        closedir($handle);
}

require_once($_exec.'functions.module.php');

// CHECKING TEMPLATE
if(!is_dir('./templates/'.$_config['template'])) $_config['template'] = 'system';

// final template variables assignment
require_once($_exec.'templater.php');

// job is done - diplaying page
$s->display($_work_templ);