<?php
        /**
         * This program is free software; you can redistribute it and/or modify
    * it under the terms of the GNU General Public License as published by
    * the Free Software Foundation; either version 2 of the License, or
    * (at your option) any later version.
    *
    * This program is distributed in the hope that it will be useful,
    * but WITHOUT ANY WARRANTY; without even the implied warranty of
    * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    * GNU General Public License for more details.
         *
    * You should have received a copy of the GNU General Public License
    * along with this program; if not, write to the Free Software
    * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
         *
         *
         * @Package Simple Captcha Script
         * @Author  Hamid Alipour, http://www.hamidof.com/
        **/

        /**
         * Start a session
        **/
        session_start();

        /**
         * Send PNG headers to the browser
        **/
        header('content-type: image/png');

        $numbers         = array();
        $numbers[]        = rand(1, 9);
        $numbers[]  = rand(1, 9);

        if(rand(0, 1) == 0) {
                $_op                                                 = '+';
                $code                                                = strval($numbers[0]) .' + ' .strval($numbers[1]) .' =';
                $_SESSION['CAPTCHA'] = $numbers[0] + $numbers[1];
        } else {
                $_op                                                 = '*';
                $code                                                = strval($numbers[0]) .' x ' .strval($numbers[1]) .' =';
                $_SESSION['CAPTCHA'] = $numbers[0] * $numbers[1];
        }
        session_write_close();

        /* Our TTF font file, you may use others */
        $font = dirname(__FILE__) .'/fonts/arial.ttf';

        /* set the width */
        $width  = 16;
        //$width  = (strlen($code) * $width) + 2;
        $height = 24;

        $code_length = 7;

        $image_height = $height + 2;
        $image_width  = $width * $code_length + 20;

        $im = imagecreatetruecolor($image_width, $image_height);
        // transparency add
        imagesavealpha($im, true);
        $white = imagecolorallocate($im, rand(0,0), rand(1,1), rand(127,128));
        // transparent color
        $trans_colour = imagecolorallocatealpha($im, 0, 0, 0, 127);
        // imagefill($im, 0, 0, $white);
        // filling image with "transparency"
        imagefill($im, 0, 0, $trans_colour);

        /* Some themes */
        $theme = array();

        $theme[] = array('CHAR_COLOR' => array('R' => array(200, 255),'G' => array(0, 100),'B' => array(0, 106)),
                         'BG_COLOR' => array('R' => array(120, 130),'G' => array(120, 130),'B' => array(110, 130)));

        $theme[] = array('CHAR_COLOR' => array('R' => array(200, 255),'G' => array(0, 100),'B' => array(1, 163)),
                         'BG_COLOR' => array('R' => array(130, 155),'G' => array(120, 130),'B' => array(120, 130)));

        $theme[] = array('CHAR_COLOR' =>array('R' => array(200, 255),'G' => array(0, 50),'B' => array(58, 178)),
                         'BG_COLOR' => array('R' => array(114, 130),'G' => array(117, 130), 'B' => array(130, 155)));

        $pos_x         = 5;
        $pos_y         = 20;
        $random = rand(0, (count($theme) - 1) );/* Get a random theme */

        /**
         *        Place each character into the image
        **/
        $angle        = 0;
        $size           = 16;

        for($i = 0, $count = strlen($code); $i < $count; $i++) {
                $color  = imagecolorallocate($im,
                                             rand($theme[$random]['CHAR_COLOR']['R'][0], $theme[$random]['CHAR_COLOR']['R'][1]),
                                             rand($theme[$random]['CHAR_COLOR']['G'][0], $theme[$random]['CHAR_COLOR']['G'][1]),
                                             rand($theme[$random]['CHAR_COLOR']['B'][0], $theme[$random]['CHAR_COLOR']['B'][1])
                                             );

                imagettftext($im, $size, $angle, $pos_x, $pos_y, $color, $font, $code{$i});
                $pos_x  += $width + 1;

        }

        /* Finally show image */
        imagepng($im);
        imagedestroy($im);
?>