<?php

if(!defined('ANTI_DIRECT')) exit(header('location: ../'));

function makepass ($length) {
        $pass = substr(md5(uniqid(rand())),0,$length);
        return $pass;
}

function is_email($email) {
        if (ereg('^([._a-zA-Z0-9-]+[._a-zA-Z0-9-]*)@(([a-zA-Z0-9-]+\.)*([a-zA-Z0-9-]+)(\.[a-zA-Z]{2,4}))$', $email)) {
                return true;
        }
        return false;
}

function cleanSpace($dir) {
        if(is_dir($dir)) {
                $handle = opendir($dir);
                while (false !== ($file = readdir($handle))) {
                         if ($file != "." && $file != "..") {
                                  if(is_file($dir.'/'.$file)) {
                                          unlink($dir.'/'.$file);
                                  } elseif(is_dir($dir.'/'.$file)) {
                                          cleanSpace($dir.'/'.$file);
                                  }
                         }
                }
                closedir($handle);
                rmdir($dir);
        }
        return true;
}

function check_referer() {
        global $_SERVER;

        if($_SERVER['HTTP_REFERER']){
                $checking = parse_url($_SERVER['HTTP_REFERER']);
                $current_host = parse_url($_SERVER['HTTP_HOST']);
                // POSSIBLE SUBMISSION FROM ANOTHER HOST
                if($checking['host'] != $current_host['host']){
                        exit(header("Location: ?bad_referer"));
                }
        // REFERER -- BOOKMARK
        } else {
                exit(header("Location: ?bad_referer"));
        }
}

function sanitize($array) {
        $new_array = array();
        if (is_array($array)) {
                while(list($key,$value) = each($array)) {
                        if (is_array($value)) {
                                $new_array[$key] = sanitize($value);
                        } elseif(!is_null($value)) {
                                $new_array[$key] = sanitize_value($value);
                        }
                }
        } elseif(!empty($array)) {
                $new_array = sanitize_value($array);
        }
        return $new_array;
}

function sanitize_value($value,$value_decode=false) {
        // DO NOT change order of elements - add new to the end
        $replaces = array('&amp;'=>'&','&#39;'=>"'",'&#036;'=>'$','&quot;'=>'"','&#33;'=>'!','&lt;'=>'<','&gt;'=>'>',"&#032;"=>" ");
        if ($value_decode == true) {
                $value = html_entity_decode($value);
                $value = strtr($value, array_flip(get_html_translation_table(HTML_SPECIALCHARS,ENT_COMPAT)));
                $replaces = array_reverse($replaces,true);
                $value = str_replace(array_keys($replaces),array_values($replaces),$value);
        } else {
                $value = str_replace("\\\"", "\"", $value);
                $value = str_replace("\\'", "'", $value); // <-- ^
                $value = str_replace("\\\\", "\\", $value); // <!-- ^^
                $value = str_replace(array_values($replaces),array_keys($replaces),$value);
        }
        return $value;
}

// function to control output errors in language files
// to prevent site crush in case of PHP parse errors
function check_language($module) {
        global $_modules_dir,$_config;

        $paths = array(
                       $_modules_dir.$_config['module_prefix'].$module.'/language.php',
                       $_config['templates_dir'].'/_custom_language/'.strtolower($_config['module_prefix'].$module).'.php',
                       $_modules_dir.$module.'/language.php',
                       $_config['templates_dir'].'/_custom_language/'.strtolower($module).'.php'
                       );
        foreach($paths AS $file) {
                if(is_file($file)) {
                        $new_return = fill_language($file);
                        if(!$return && !empty($new_return)) $return = $new_return;
                }
        }
        print $return;
        return $return;
}

function fill_language($file) {
        global $_language,$_GET,$_SERVER,$BASE_URI,$_config,$_POST;
        ini_set('implicit_flush',false);
        ob_start();
        $_replaces = array('<?php','?>','<?');
        if(!eval(str_replace($_replaces,'',join('',file($file))))) $error = ob_get_contents();;
        ob_end_clean();
        ini_set('implicit_flush',true);
        if(strlen($error) > 0) {
                $chunks = explode('/',$file);
                preg_match("#parse error,(.*)in#sU",$error,$error_string);
                $error = 'Error in language file: '.$error_string[0].' '.$chunks[count($chunks)-1];
                return $error;
        }
}

function string2array($string) {
        if(strlen($string) > 0) {
                $array = explode(' ',trim(str_replace('&#032;',' ',str_replace(',','',$string))));
                if(count($array) > 0) {
                        $new_array = array();
                        foreach($array AS $value) {
                                if(!empty($value)) $new_array[] = $value;
                        }
                }
                if(empty($new_array[0])) unset($new_array);
        }
        return $new_array;
}